<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\SessionController;
use App\Http\Controllers\ViewerController;

Route::get('/', function () {
    return view('welcome');
});

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');

// Session management endpoints
Route::post('/sessions', [SessionController::class, 'create']);
Route::put('/sessions/{publicId}/location', [SessionController::class, 'updateLocation'])->middleware('rate.limit.location');
Route::post('/sessions/{publicId}/stop', [SessionController::class, 'stop']);

// Viewer endpoints (signed routes)
Route::get('/view/{publicId}', [ViewerController::class, 'view'])->name('view.session');
Route::get('/view/{publicId}/history', [ViewerController::class, 'history'])->name('view.history');
