<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('location_sessions', function (Blueprint $table) {
            $table->id();
            $table->string('public_id')->unique();
            $table->string('owner_token');
            $table->string('viewer_token');
            $table->decimal('last_lat', 10, 8)->nullable();
            $table->decimal('last_lng', 11, 8)->nullable();
            $table->integer('battery')->nullable();
            $table->timestamp('last_updated')->nullable();
            $table->timestamp('expires_at')->nullable();
            $table->enum('status', ['active', 'ended'])->default('active');
            $table->timestamps();
            
            $table->index(['public_id', 'status']);
            $table->index('expires_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('location_sessions');
    }
};
