<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Carbon\Carbon;

class Session extends Model
{
    protected $table = 'location_sessions';
    
    protected $fillable = [
        'public_id',
        'owner_token',
        'viewer_token',
        'last_lat',
        'last_lng',
        'battery',
        'last_updated',
        'expires_at',
        'status',
    ];

    protected $casts = [
        'last_lat' => 'decimal:8',
        'last_lng' => 'decimal:8',
        'battery' => 'integer',
        'last_updated' => 'datetime',
        'expires_at' => 'datetime',
    ];

    public function locationHistories(): HasMany
    {
        return $this->hasMany(LocationHistory::class);
    }

    public function isActive(): bool
    {
        return $this->status === 'active' && $this->expires_at->isFuture();
    }

    public function isExpired(): bool
    {
        return $this->expires_at->isPast();
    }

    public function scopeActive($query)
    {
        return $query->where('status', 'active')
                    ->where('expires_at', '>', now());
    }

    public function scopeExpired($query)
    {
        return $query->where('expires_at', '<=', now());
    }
}
