<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class LocationHistory extends Model
{
    protected $fillable = [
        'session_id',
        'lat',
        'lng',
        'battery',
        'recorded_at',
    ];

    protected $casts = [
        'lat' => 'decimal:8',
        'lng' => 'decimal:8',
        'battery' => 'integer',
        'recorded_at' => 'datetime',
    ];

    public function session(): BelongsTo
    {
        return $this->belongsTo(Session::class);
    }

    public function scopeInTimeRange($query, $from = null, $to = null)
    {
        if ($from) {
            $query->where('recorded_at', '>=', $from);
        }
        
        if ($to) {
            $query->where('recorded_at', '<=', $to);
        }
        
        return $query;
    }

    public function scopeOrderedByTime($query)
    {
        return $query->orderBy('recorded_at', 'asc');
    }
}
