<?php

namespace App\Console\Commands;

use App\Models\Session;
use Illuminate\Console\Command;

class CleanupExpiredSessions extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'sessions:cleanup {--dry-run : Show what would be deleted without actually deleting}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Clean up expired sessions and their location history';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $expiredSessions = Session::expired()->get();
        
        if ($expiredSessions->isEmpty()) {
            $this->info('No expired sessions found.');
            return 0;
        }

        $this->info("Found {$expiredSessions->count()} expired sessions.");

        if ($this->option('dry-run')) {
            $this->info('Dry run mode - no sessions will be deleted.');
            foreach ($expiredSessions as $session) {
                $this->line("Would delete session: {$session->public_id} (expired: {$session->expires_at})");
            }
            return 0;
        }

        $deletedCount = 0;
        foreach ($expiredSessions as $session) {
            $session->delete(); // This will cascade delete location histories
            $deletedCount++;
        }

        $this->info("Successfully deleted {$deletedCount} expired sessions and their location history.");
        return 0;
    }
}
