# Dima M3ak Backend

A production-ready Laravel 11 backend for live-location sharing application.

## Features

- **Session Management**: Create, update, and stop location sharing sessions
- **Real-time Location Updates**: Send location data every 10 seconds with rate limiting
- **Secure Viewer Access**: Signed URLs for read-only session viewing
- **Location History**: Retrieve complete location history with polyline encoding
- **Automatic Cleanup**: Expired session cleanup command
- **Production Ready**: Rate limiting, validation, and error handling

## Quick Start

### Prerequisites

- PHP 8.2+
- Composer
- SQLite (default) or MySQL/PostgreSQL

### Installation

1. Clone the repository
2. Install dependencies:
   ```bash
   composer install
   ```

3. Set up environment:
   ```bash
   cp .env.example .env
   php artisan key:generate
   ```

4. Run migrations:
   ```bash
   php artisan migrate
   ```

5. Start the server:
   ```bash
   php artisan serve
   ```

The API will be available at `http://localhost:8000/api`

## API Endpoints

| Method | Endpoint | Description |
|--------|----------|-------------|
| POST | `/api/sessions` | Create new session |
| PUT | `/api/sessions/{id}/location` | Update location |
| POST | `/api/sessions/{id}/stop` | Stop session |
| GET | `/api/view/{id}` | View session status |
| GET | `/api/view/{id}/history` | Get location history |

## Usage Examples

### Create Session
```bash
curl -X POST http://localhost:8000/api/sessions
```

### Update Location
```bash
curl -X PUT http://localhost:8000/api/sessions/{publicId}/location \
  -H "X-Session-Token: {ownerToken}" \
  -H "Content-Type: application/json" \
  -d '{"lat": 40.7128, "lng": -74.0060, "battery": 85}'
```

### View Session
```bash
curl "{viewerUrl}"
```

## Maintenance

### Cleanup Expired Sessions
```bash
# Dry run to see what would be deleted
php artisan sessions:cleanup --dry-run

# Actually delete expired sessions
php artisan sessions:cleanup
```

### Schedule Cleanup (Production)
Add to crontab:
```bash
0 * * * * cd /path/to/app && php artisan sessions:cleanup
```

## Documentation

For complete API documentation with examples and frontend integration guide, see [API_DOCUMENTATION.md](./API_DOCUMENTATION.md).

## Security

- Token-based authentication
- Signed URLs for viewer access
- Rate limiting (10 seconds between location updates)
- Input validation and sanitization
- Automatic session expiration

## Database Schema

### Location Sessions Table
- `public_id`: Unique session identifier
- `owner_token`: Token for session control
- `viewer_token`: Token for read-only access
- `last_lat/lng`: Current location
- `battery`: Battery percentage
- `expires_at`: Session expiration
- `status`: active/ended

### Location History Table
- `session_id`: Foreign key to location_sessions
- `lat/lng`: Location coordinates
- `battery`: Battery at time of recording
- `recorded_at`: Timestamp

## Production Deployment

1. Set up production database (MySQL/PostgreSQL)
2. Configure environment variables
3. Set up SSL/HTTPS
4. Configure web server (Nginx/Apache)
5. Set up scheduled cleanup task
6. Monitor logs and performance

## License

This project is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).